#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Iridescent Rounded VoronoiMod01.fsh  by  AieKick  
//https://www.shadertoy.com/view/ttlSDl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// base code from shane : https://www.shadertoy.com/view/4sdcDN
// fork of my : https://www.shadertoy.com/view/tslXWX

const float _threshold = 0.0;
const vec3 _cellColor = vec3(0.2,0.6,0.7);
const float _zoom = 1.0;

float objID; // The rounded web lattice, or the individual Voronoi cells.
vec2 cellID;

mat2 r2(in float a){ float c = cos(a), s = sin(a); return mat2(c, -s, s, c); }

float smin2(float a, float b, float r)
{
   float f = max(0., 1. - abs(b - a)/r);
   return min(a, b) - r*.25*f*f;
}

vec2 hash22H(vec2 p) 
{ 
    float n = sin(dot(p, vec2(41, 289)));
    p = fract(vec2(262144, 32768)*n);
    return sin( p*6.2831853 + iTime )*.3660254 + .5; 
}

vec2 pixToHex(vec2 p)
{
    return floor(vec2(p.x + .57735*p.y, 1.1547*p.y));
}

vec2 hexPt(vec2 p) 
{
    return vec2(p.x - p.y*.5, .866025*p.y) + (hash22H(p) - .5)*.866025/2.;
    
}

vec3 Voronoi(vec2 p)
{
    vec2 pH = pixToHex(p); // Map the pixel to the hex grid.
	const vec2 hp[7] = vec2[7](vec2(-1), vec2(0, -1), vec2(-1, 0), vec2(0), vec2(1), vec2(1, 0), vec2(0, 1)); 
    vec2 minCellID = vec2(0); // Redundant initialization, but I've done it anyway.
	vec2 mo, o;
    float md = 8., lMd = 8., lMd2 = 8., lnDist, d;
    for (int i=0; i<7; i++)
	{
        vec2 h = hexPt(pH + hp[i]) - p;
    	d = dot(h, h);
    	if( d<md )
		{
            md = d;  // Update the minimum distance.
            mo = h; 
            minCellID = hp[i]; // Record the minimum distance cell ID.
        }
    }

	float r = mix(0.0,0.4,sin(iTime * 0.5)*0.5+0.5);
    
	if (iMouse.z > 0.0)
		r = mix(0.0,0.4,iMouse.x/iResolution.x);
    
    for (int i=0; i<7; i++)
	{
        vec2 h = hexPt(pH + hp[i] + minCellID) - p - mo; // Note the "-mo" to save some operations. 
        if(dot(h, h)>.00001){
            lnDist = dot(mo + h*.5, normalize(h));
            lMd = smin2(lMd, lnDist, (lnDist*.5 + .5)*r);
            lMd2 = min(lMd2, lnDist);
			cellID = vec2(lMd);
        }
    }

    float t = iTime * 5.;
    d = lMd * 25.;
    mo -= vec2(cos(d + t),sin(d + t)) / d;
    lMd2 = length(mo);
	
    return max(vec3(lMd, lMd2, md), 0.);
}

float bumpFunc(vec2 p)
{
    vec3 v = Voronoi(p);
    float c = v.x; // Rounded edge value.
    float ew = _threshold; // Border threshold value. Bigger numbers mean thicker borders.
    if(c<ew)
	{ 
        objID = 1.; // Voronoi web border ID.
        c = abs(c - ew)/ew; // Normalize the domain to a range of zero to one.
        c = smoothstep(0., .25, c)/4. + clamp(-cos(c*6.283*1.5) - .5, 0., 1.);
    }
    else 
	{ // Over the threshold? Use the regular Voronoi cell value.
        objID = 0.;
        c = mix(v.x,  v.y, .75); // A mixture of rounded and straight edge values.
        c = (c - ew)/(1. - ew); // Normalize the domain to a range of zero to one.
        c = clamp(c + cos(c*6.283*24.)*.002, 0., 1.); // Add some ridges.
    }
    return c; // Return the object (bordered Voronoi) value.
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
	cellID = vec2(0);
	vec2 uv = (fragCoord - iResolution.xy*.5)/min(iResolution.y, 800.) * _zoom;
    vec2 aspect = vec2(iResolution.y/iResolution.x, 1);
    uv *= 1. + dot(uv*aspect, uv*aspect)*.05;
    vec3 r = normalize(vec3(uv.xy, 1.));
    vec2 p = uv*3.5 + vec2(0, iTime*.5);
    float c = bumpFunc(p);
    float svObjID = objID; 
    vec3 sp = vec3(p, 0.);
    vec3 lp = sp + vec3(-1.3*sin(iTime/2.), .8*cos(iTime/2.), -.5);
    vec3 lp2 = sp + vec3(1.3*sin(iTime/2.), -.8*cos(iTime/2.), -.5);
    sp.z -= c*.1;
    vec2 e = vec2(8./iResolution.y, 0); // Sample spred.
    float bf = .4; // Bump factor.
    if (svObjID>.5) { e.x = 2./iResolution.y; }
    float fx = (bumpFunc(p - e) - bumpFunc(p + e)); // Nearby horizontal samples.
    float fy = (bumpFunc(p - e.yx) - bumpFunc(p + e.yx)); // Nearby vertical samples.
	vec3 n = normalize(vec3(fx, fy, -e.x/bf)); // Bumped normal.
    float edge = abs(c*2. - fx) + abs(c*2. - fy); // Edge value.
    vec3 tx = texture2D(texture0, (p + n.xy*.125)*.25).xyz; tx *= tx; // sRGB to linear.
    tx = smoothstep(0., .5, tx); // Accentuating the color a bit.
    vec3 oCol = tx; 
    if(svObjID>.5)
	{
        oCol *= 1.-_cellColor;
    }   
    else
	{
        oCol *= _cellColor; 
    }
	
	oCol.xy *= cellID * 10.;
	
    float lDist = length(lp - sp); // Light distance one.
    float atten = 1./(1. + lDist*lDist*.5); // Light one attenuation.
    vec3 l = (lp - sp)/max(lDist, .001); // Light one direction (normalized).
	float diff = max(max(dot(l, n), 0.), 0.); // Diffuse value one.
    float spec = pow(max(dot(reflect(l, n), r), 0.), 64.); // Specular value one.
    
    float lDist2 = length(lp2 - sp); // Light distance two.
    float atten2 = 1./(1. + lDist2*lDist2*.5); // Light two attenuation.
    vec3 l2 = (lp2 - sp)/max(lDist2, .001); // Light two direction (normalized).
	float diff2 = max(max(dot(l2, n), 0.), 0.); // Diffuse value two.
    float spec2 = pow(max(dot(reflect(l2, n), r), 0.), 64.); // Specular value twp.
    
    diff = pow(diff, 4.)*2.;
    diff2 = pow(diff2, 4.)*2.;

    vec3 col = oCol*(diff*vec3(.5, .7, 1) + .25 + vec3(.25, .5, 1)*spec*32.)*atten*.5;
    
    col += oCol*(diff2*vec3(1, .7, .5) + .25 + vec3(1, .3, .1)*spec2*32.)*atten2*.5;

	if(svObjID>.5)
	{
        col *= edge;
    }   
    else 
	{
        col /= edge;
    }
        
    vec2 u = fragCoord/iResolution.xy;
    col *= pow(16.*u.x*u.y*(1. - u.x)*(1. - u.y) , .125);

    fragColor = vec4(sqrt(max(col, 0.)), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

